// RTOS_serial.h for RTOS_Serial Project
//Copyright Rob Silbert Limited, LLC
//
//http://mysite.verizon.net/vze124b2u/
//Written by Rob Silbert
//rsilbert@yahoo.com
//mobile: 
//Started April 27, 2010

/*
	This file is part of pqrst commander.

    pqrst commander is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pqrst commander is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pqrst commander.  If not, see <http://www.gnu.org/licenses/>.
*/

#define ROB						4

#define OFF						0x00
#define ON						0x01
#define SLEEP					0x00
#define IDLE_MINUTES			0x04
#define LOW_BATTERY				0x01
#define	BATTERY_OK				0x00
#define TRU						1
#define FALSE					0
#define ERROR					0xA0
#define SET						0x01
#define BACKSLASH				0x5C
#define LINEFEED				0x0A
#define CARRIAGERETURN			0x0D
#define EOT						0x04
#define COMMAND					0x00
#define CONFIG					0x01
//Command Value Positions
#define PORT_NUMBER_POSITION	2
#define PERIOD_POSITION			3
#define xPOSITION				4
#define HIGH_NIBBLE				5
#define LOW_NIBBLE				6
#define BIT_POSITION			6			
#define FIRST_DECIMAL_POSITION	4
#define SECOND_DECIMAL_POSITION	5
#define THIRD_DECIMAL_POSITION	6
#define USER_NUMBER				2

//Memory Locations
#define USERNAME_OFFSET			0x10
#define	PASSWORD_OFFSET			0x20
#define USERNAME2_OFFSET		0x30
#define PASSWORD2_OFFSET		0x40
#define FLASH_SETTINGS_ST_ADDR	0x1000
#define FLASH_SETTINGS_B2_ADDR	0x1080
#define USERNAME_START_ADDR		FLASH_SETTINGS_ST_ADDR + USERNAME_OFFSET	//16
#define PASSWORD_START_ADDR		FLASH_SETTINGS_ST_ADDR + PASSWORD_OFFSET	//32
#define USERNAME2_START_ADDR	FLASH_SETTINGS_ST_ADDR + USERNAME2_OFFSET	//48
#define PASSWORD2_START_ADDR	FLASH_SETTINGS_ST_ADDR + PASSWORD2_OFFSET	//64
#define CONFIG_FILE_ST_ADDR		PASSWORD2_START_ADDR + 16					//64 + 16 = 80
#define CONFIG_FILE_ST_OFFSET	PASSWORD2_OFFSET + 16
																			//128 - 80 = 48
#define APPLICATION_INTERNAL	FLASH_SETTINGS_ST_ADDR + 0x50				//This value is not correct
#define APPLICATION_EXTERNAL	FLASH_SETTINGS_ST_ADDR + 0x54				//This value is not correct
//Command List
	
//SYSTEM COMMANDS
//----------------------
#define INVALID					0x00
#define ps						0x01//ps1			PS1
#define cl						0x02//cl			clear
#define v						0x03//v				version
#define lo						0x05//lo			logout
#define h						0x06//?				help
#define user					0x07//su			set user #

//Hardware Control
//----------------------
#define sp						0x31//sp			set port P#OUT
//#define sb						//sb			set bit

//#define cb						//cb			clear bit
#define pr						0x33//P#IN			port read
#define pd						0x34//P#DIR			port direction
#define pm						0x35//P#SEL			port selection (MUX)
#define pi						0x36//P#IE			port interrupts
#define de						0x37//OSDelay		delay of 10ms ticks
//Memory Read/Write
//----------------------
#define we						0x3A//we			write external mem
#define re						0x3B//re			read external mem
#define wi						0x4A//wi			write internal mem
#define ri						0x4B//ri			read internal mem

#define default_prompt			"MSP430F149"
//ADC Control
//----------------------
//sa(DC)		start/stop adc
//ra(DC)		read adc

//Files
//-----------------------
//wr			write
//rd			rd
//st			start
//de			delete
//li			list
//ru			run
//sp			stop
//if			if
//ls			loop start
//lp			loop stop
//as			auto start
//cp			copy

//Function ProtoTypes
//Command.c
void CommandPrintStartupMessage(void);
void CommandLoginPrompt(void);
void CommandPasswordPrompt(void);
unsigned char CommandLoginHandler(void);
void CommandPrintSerialPrompt(void);
unsigned char CommandCheckForReturnKey(void);
unsigned char CommandCheckForValidCommand(void);
unsigned char CommandHandleCommandSetPort(void);
unsigned char CommandHandleCommandPromptString(void);
unsigned char CommandHandleCommandClearScreen(void);
unsigned char CommandHandleCommandVersion(void);
unsigned char CommandHandleCommandHelp(void);
unsigned char CommandHandleCommandLogOut(void);
unsigned char CommandHandleCommandPortRead(void);
unsigned char CommandHandleCommandPortDirection(void);
unsigned char CommandHandleCommandPortMUX(void);
unsigned char CommandHandleCommandSetUser(void);
unsigned char CommandConvAsciiToNumeric (unsigned char);
void CommandHandleCommandReboot(void);
unsigned char CommandHandleCommandMemoryRead(void);
void CommandHandleCommandReset(void);
unsigned char CommandHandleCommandLoadConfig(void);
void CommandHandleCommandPrintLine(void);
void CommandHandleBackspaces(void);

//flash.c
void FlashInit(void);
unsigned char FlashRead(unsigned char *);
void FlashWrite(unsigned char *, unsigned char);
void FlashErase(unsigned char *);
void ROMLCDWrite(unsigned char, unsigned char);
unsigned char WriteUARTData(unsigned char);
void UARTInit(void);
void UARTShutdown(void);
void FlashPortSetup(void);
void UARTPrint(unsigned char *);



#define UARTInitTX()			do{ BCSCTL2 &= ~(DIVS0 | DIVS1);		\
								P3OUT |= BIT2; 							\
								P2OUT &= ~BIT7; 						\
								_BIC_SR(SCG1); /*Enable SMCLK*/ 		\
								UCTL0 = CHAR;  /* 8-bit character */ 	\
								UTCTL0 |= (SSEL0 | SSEL1);  			\
								UBR00 = 0xC0; 							\
								UBR10 = 0x00;							\
								UMCTL0 = 0x00;	/* No Modulation*/		\
								ME1 |= UTXE0 + URXE0;					\
								IE1 |= URXIE0;							\
								P3SEL |= 0x30;							\
								} while (0)

//Below setup is for my specific hardware
//#define	FlashPortSetup()		do{P1OUT = 0;							\
//    							P1DIR = 0xCA; /*0y11001010 = 0xCA*/		\
//   							P1SEL = 0;								\
//        						P2OUT = 0x80; /*0y10000000*/			\
//    							P2DIR = 0xB4; /*0y10110100 = 0xB4*/		\
//    							P2SEL = 0x00;							\
//         						P3OUT = 0xC2; /*0y11000000*/			\
//    							P3DIR = 0x57; /*0y01010111= 0x57*/		\
// 								P3SEL = 0x00; /*SET UP FOR UART*/		\
// 								P4OUT = 0xFF;							\
//    							P4DIR = 0xFF;							\
//    							P4SEL = 0x00;							\
//         						P5OUT = 0xFF;							\
//    							P5DIR = 0xFF;							\
//    							P5SEL = 0x60; /*0y0110 0000 = 0x60*/	\
//    							P5SEL = 0x00;							\
//								P6DIR = 0x78; /*0y01111000*/			\
//								P6SEL = 0x87;							\
//								BCSCTL2 = SELM1 + SELS;					\
//								} while(0)
								
#define	FlashPortSetup()		do{P1OUT = 0;							\
    							P1DIR = 0x00; /*0y11001010 = 0xCA*/		\
    							P1SEL = 0x00;								\
        						P2OUT = 0x00; /*0y10000000*/			\
    							P2DIR = 0x00; /*0y10110100 = 0xB4*/		\
    							P2SEL = 0x00;							\
          						P3OUT = 0xC2; /*0y11000000*/			\
    							P3DIR = 0x57; /*0y01010111= 0x57*/		\
 								P3SEL = 0x00; /*SET UP FOR UART*/		\
 								P4OUT = 0x00;							\
    							P4DIR = 0x00;							\
    							P4SEL = 0x00;							\
          						P5OUT = 0x00;							\
    							P5DIR = 0x00;							\
    							P5SEL = 0x00; /*0y0110 0000 = 0x60*/	\
    							P5SEL = 0x00;							\
								P6DIR = 0x00; /*0y01111000*/			\
								P6SEL = 0x00;							\
								BCSCTL2 = SELM1 + SELS;					\
								} while(0)								
								
/*Notes: */
/*
Immediate:
-------------
[  ] Write to internal memory
[ x ] Constant display of port values
[  ] Creating of a file that can be autorun
[ x ] Alternate logins.


Notes:
-------------
[ x ] Need to add config file for port settings
[  ] Need to add config file for UART settings, so setup can be changed.


Versions
-------------
00.01	Basic functionality.  Got some of the code working
00.02  	Fixed all of the login issues.  Everything coded appears to work
00.03	Adding more functionality: Change of Startup screen. Port set working
		sprintf was not yielding numerics from ascii. 
		Code size 15,156, including debug code
00.04	Lost work on version 4.  Redid in version 5
00.05	Completing set port functionality and read port.
00.06   Constant Port status display, config file




*/